﻿Imports System.Globalization.CultureInfo

Public Class frmMain

    ' This is a test harness to demonstrate conversion of RA and Dec coordinates
    ' to Altitude and Azimuth.
    '
    ' Two sets of test data are pre-defined, one for an observer in Southern England and
    ' one for NSW Australia (Sydney).
    '
    ' Keith Ehren
    ' www.astroworkbench.co.uk

    ReadOnly util As New utils  ' Class containing utility functions
    ReadOnly conv As New RADecToAltAz ' Class containing code to convert RA and Dec to Alt and Az

    Private mUnitTestLocalDateTime As DateTime  ' Member variables used for the test data

    Private mUnitTestRAHrs As Integer
    Private munitTestRAMins As Integer
    Private mUnitTestRASecs As Double

    Private mUnitTestDecDegs As Integer
    Private mUnitTestDecMins As Integer
    Private mUnitTestDecSecs As Double
    Private mUnitTestDecNorthSouth As String

    Private mUnitTestTZ As Double
    Private mUnitTestDS As Integer

    Private mUnitTestLatitude As Double
    Private mUnitTestLongitude As Double



    Private Sub frmMain_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Try

            ' Set up test date set 1 - observer at Southern England
            setParameterValuesSet1()

        Catch ex As Exception
            util.Err(ex.Message, System.Reflection.MethodBase.GetCurrentMethod.Name)
        End Try

    End Sub

    Private Sub rbTestDataSet1_CheckedChanged(sender As Object, e As EventArgs) Handles rbTestDataSet1.CheckedChanged, rbTestDataSet2.CheckedChanged

        If rbTestDataSet1.Checked Then
            ' Set up test date set 1 - observer at Southern England
            setParameterValuesSet1()
        Else
            ' Set up test date set 2 - observer at Sydney Australia
            setParameterValuesSet2()
        End If

    End Sub


    ' Set the fixed values for test parameters for data set 1.
    ' Observers location is Southern England.
    Private Sub setParameterValuesSet1()

        Try

            ' Date and time parameters

            mUnitTestLocalDateTime = DateTime.ParseExact("20 AUG 2020 18:39:10", "dd MMM yyyy HH:mm:ss", InvariantCulture) ' 24 Hr time format
            mUnitTestTZ = 0  ' Time zone is zero for the longitude used in this test
            mUnitTestDS = 1 ' Daylight saving is active (i.e. plus 1 hour) as the date and location used in this test is British Summer

            'RA and Dec parameers (for Vega)
            mUnitTestRAHrs = 18
            munitTestRAMins = 36
            mUnitTestRASecs = 0

            mUnitTestDecDegs = 38
            mUnitTestDecMins = 47
            mUnitTestDecSecs = 0
            mUnitTestDecNorthSouth = "North"

            ' Observer location parameters (Southern England)
            mUnitTestLatitude = 51.758333 ' 51:45:30 North (North = positive)
            mUnitTestLongitude = -1.838889 ' 1:50:20 West (West = negative)

            ' Display the values
            txtLocalDate.Text = mUnitTestLocalDateTime.ToLongDateString
            txtLocalTime.Text = mUnitTestLocalDateTime.ToLongTimeString

            txtRAHrs.Text = mUnitTestRAHrs
            txtRAMins.Text = munitTestRAMins
            txtRASecs.Text = mUnitTestRASecs

            txtDecDegs.Text = mUnitTestDecDegs
            txtDecMIns.Text = mUnitTestDecMins
            txtDecSecs.Text = mUnitTestDecSecs
            txtDecNorthSouth.Text = mUnitTestDecNorthSouth ' North is positive Dec, South is negative

            txtTZ.Text = mUnitTestTZ
            txtDS.Text = mUnitTestDS

            Dim lHr As Integer
            Dim lMn As Integer
            Dim lSecs As Double

            util.decimalToHMS(mUnitTestLatitude, lHr, lMn, lSecs)
            txtLatitude.Text = mUnitTestLatitude & " (" & lHr.ToString("00") & ":" & lMn.ToString("00") & ":" & lSecs.ToString("00") & ")"

            util.decimalToHMS(mUnitTestLongitude, lHr, lMn, lSecs)
            txtLongitude.Text = mUnitTestLongitude & " (" & lHr.ToString("00") & ":" & lMn.ToString("00") & ":" & lSecs.ToString("00") & ")"

            lblExpectedAlt.Text = "55.478"
            lblExpectedAz.Text = "93.388"
            lblExpectedGST.Text = "15:37:14"
            lblExpectedUT.Text = "17:39:10"
            lblExpectedLST.Text = "15:29:53"

            txtActualResultAlt.Clear()
            txtActualResultAZ.Clear()
            txtGST.Clear()
            txtUT.Clear()
            txtLST.Clear()



        Catch ex As Exception
            util.Err(ex.Message, System.Reflection.MethodBase.GetCurrentMethod.Name)
        End Try

    End Sub

    ' Set the fixed values for test parameters for data set 1.
    ' Observers location is Australia.
    Private Sub setParameterValuesSet2()

        Try

            ' Date and time parameters
            mUnitTestLocalDateTime = DateTime.ParseExact("10 JUL 2020 03:20:15", "dd MMM yyyy HH:mm:ss", InvariantCulture) ' 24 Hr time format
            mUnitTestTZ = 10  ' Time zone is +10 hours for Sydney
            mUnitTestDS = 0 ' Daylight saving is not active as July is Australian winter

            'RA and Dec parameers (for Vega)
            mUnitTestRAHrs = 18
            munitTestRAMins = 36
            mUnitTestRASecs = 0

            mUnitTestDecDegs = 38
            mUnitTestDecMins = 47
            mUnitTestDecSecs = 0
            mUnitTestDecNorthSouth = "North"

            ' Observer location parameters (NSW Australia)
            mUnitTestLatitude = -33.8688 ' South = negative
            mUnitTestLongitude = 151.2093 ' East = positive

            ' Display the values
            txtLocalDate.Text = mUnitTestLocalDateTime.ToLongDateString
            txtLocalTime.Text = mUnitTestLocalDateTime.ToLongTimeString

            txtRAHrs.Text = mUnitTestRAHrs
            txtRAMins.Text = munitTestRAMins
            txtRASecs.Text = mUnitTestRASecs

            txtDecDegs.Text = mUnitTestDecDegs
            txtDecMIns.Text = mUnitTestDecMins
            txtDecSecs.Text = mUnitTestDecSecs
            txtDecNorthSouth.Text = mUnitTestDecNorthSouth ' North is positive Dec, South is negative

            txtTZ.Text = mUnitTestTZ
            txtDS.Text = mUnitTestDS

            Dim lHr As Integer
            Dim lMn As Integer
            Dim lSecs As Double

            util.decimalToHMS(mUnitTestLatitude, lHr, lMn, lSecs)
            txtLatitude.Text = mUnitTestLatitude & " (" & lHr.ToString("00") & ":" & lMn.ToString("00") & ":" & lSecs.ToString("00") & ")"

            util.decimalToHMS(mUnitTestLongitude, lHr, lMn, lSecs)
            txtLongitude.Text = mUnitTestLongitude & " (" & lHr.ToString("00") & ":" & lMn.ToString("00") & ":" & lSecs.ToString("00") & ")"

            lblExpectedAlt.Text = "-1.671"
            lblExpectedAz.Text = "317.318"
            lblExpectedGST.Text = "12:32:41"
            lblExpectedUT.Text = "17:20:15"
            lblExpectedLST.Text = "22:37:31"

            txtActualResultAlt.Clear()
            txtActualResultAZ.Clear()
            txtGST.Clear()
            txtUT.Clear()
            txtLST.Clear()


        Catch ex As Exception
            util.Err(ex.Message, System.Reflection.MethodBase.GetCurrentMethod.Name)
        End Try

    End Sub

    Private Sub btnConvert_Click(sender As Object, e As EventArgs) Handles btnConvert.Click

        Try

            runTest()

        Catch ex As Exception
            util.Err(ex.Message, System.Reflection.MethodBase.GetCurrentMethod.Name)
        End Try
    End Sub

    Private Sub runTest(Optional ByVal pDisplayResults As Boolean = True)

        Try

            ' Get the values to pass in to RADecToAltAz(
            Dim lLatitude As Double = util.degreesToRads(mUnitTestLatitude)
            Dim l24HrTime As Double = util.hmsToDecimal(mUnitTestLocalDateTime.Hour, mUnitTestLocalDateTime.Minute, mUnitTestLocalDateTime.Second)
            Dim lRA As Double = util.hmsToDecimal(mUnitTestRAHrs, munitTestRAMins, mUnitTestRASecs)
            Dim lDec As Double = util.hmsToDecimal(mUnitTestDecDegs, mUnitTestDecMins, mUnitTestDecSecs) ' Make -ve if South, this test is North


            ' RADecToAltAz() return values
            Dim lUT As Double
            Dim lGST As Double
            Dim lLST As Double
            Dim lAlt As Double
            Dim lAz As Double


            conv.RADecToAltAz(lRA, lDec,
                              mUnitTestLongitude, lLatitude, ' Longitude must be Degrees, latitude must be in Rads
                              mUnitTestLocalDateTime.Day, mUnitTestLocalDateTime.Month, mUnitTestLocalDateTime.Year,
                              l24HrTime, mUnitTestDS, mUnitTestTZ, lUT, lGST, lLST, lAlt, lAz)


            ' Display results

            If pDisplayResults Then

                Dim lHr As Integer
                Dim lMn As Integer
                Dim lSecs As Double

                util.decimalToHMS(lAlt, lHr, lMn, lSecs)
                txtActualResultAlt.Text = lAlt.ToString("#0.000") & " (" & lHr.ToString("00") & ":" & lMn.ToString("00") & ":" & lSecs.ToString("00") & ")"

                util.decimalToHMS(lAz, lHr, lMn, lSecs)
                txtActualResultAZ.Text = lAz.ToString("##0.000") & " (" & lHr.ToString("00") & ":" & lMn.ToString("00") & ":" & lSecs.ToString("00") & ")"

                util.decimalToHMS(lUT, lHr, lMn, lSecs)
                txtUT.Text = lHr.ToString & ":" & lMn.ToString & ":" & lSecs.ToString("00")

                util.decimalToHMS(lGST, lHr, lMn, lSecs)
                txtGST.Text = lHr.ToString & ":" & lMn.ToString & ":" & lSecs.ToString("00")

                util.decimalToHMS(lLST, lHr, lMn, lSecs)
                txtLST.Text = lHr.ToString & ":" & lMn.ToString & ":" & lSecs.ToString("00")
            End If


        Catch ex As Exception
            util.Err(ex.Message, System.Reflection.MethodBase.GetCurrentMethod.Name)
        End Try

    End Sub



    ' Run test 100,000 times for a volume and performance test
    Private Sub cmdVolumeTest_Click(sender As Object, e As EventArgs) Handles cmdVolumeTest.Click

        Try

            txtVolumeTestResult.Clear()

            Me.Cursor = Cursors.WaitCursor

            Dim stopwatch As Stopwatch = New Stopwatch()
            stopwatch.Start()

            For i As Integer = 1 To 100000
                runTest(False) ' Parameter of False so as to not display text field results for each invocation
            Next

            stopwatch.Stop()

            Me.Cursor = Cursors.Default

            txtVolumeTestResult.Text = stopwatch.ElapsedMilliseconds / 100

            runTest() ' Run once more to display results


        Catch ex As Exception
            Me.Cursor = Cursors.Default
            util.Err(ex.Message, System.Reflection.MethodBase.GetCurrentMethod.Name)
        End Try
    End Sub


    ' Run in two nested loops - For Dec -90 to 90 step 0.1 degrees and RA 0 to 24 step 0.1 hours for a stress test
    Private Sub btnLooopTest_Click(sender As Object, e As EventArgs) Handles btnLooopTest.Click

        Try

            Dim lLatitude As Double = util.degreesToRads(mUnitTestLatitude)
            Dim l24HrTime As Double = util.hmsToDecimal(mUnitTestLocalDateTime.Hour, mUnitTestLocalDateTime.Minute, mUnitTestLocalDateTime.Second)

            ' RADecToAltAz() return values
            Dim lUT As Double
            Dim lGST As Double
            Dim lLST As Double
            Dim lAlt As Double
            Dim lAz As Double

            Me.Cursor = Cursors.WaitCursor


            For lDec As Double = -90 To 90 Step 0.1

                For lra As Double = 0 To 24 Step 0.1

                    txtLoopTest.Text = "Dec " & lDec.ToString("00.0") & ", RA " & lra.ToString("00.0")
                    txtLoopTest.Refresh()

                    conv.RADecToAltAz(lra, lDec,
                                      mUnitTestLongitude, lLatitude,
                                      mUnitTestLocalDateTime.Day, mUnitTestLocalDateTime.Month, mUnitTestLocalDateTime.Year,
                                      l24HrTime, mUnitTestDS, mUnitTestTZ, lUT, lGST, lLST, lAlt, lAz)

                Next lra

            Next lDec

            txtLoopTest.Text = "Test completed"


            Me.Cursor = Cursors.Default

        Catch ex As Exception
            Me.Cursor = Cursors.Default
            util.Err(ex.Message, System.Reflection.MethodBase.GetCurrentMethod.Name)
        End Try
    End Sub


End Class
